<?php

App::uses('ShortcodeHelper', 'View/Helper');

class MightyShortcodesHelper extends ShortcodeHelper
{
    public $helpers = array('');

    public function __construct(View $View, $settings = array())
    {
        parent::__construct($View, $settings);
        // Register the shortcodes
        $this->add_shortcode(array(
            array('b', array(&$this, 'shortcode_bold')),
            array('element', array(&$this, 'shortcode_element')),
        ));
    }
    /*
    function _beforeShortcode($content) {
        return htmlspecialchars($content);
    }

    function _afterShortcode($content) {
        return nl2br($content);
    }
    */

    // No-name attribute fixing
    public function attributefix($atts = array())
    {
        if (empty($atts[0])) {
            return $atts;
        }

        if (0 !== preg_match('#=("|\')(.*?)("|\')#', $atts[0], $match)) {
            $atts[0] = $match[2];
        }

        return $atts;
    }

    // Bold shortcode
    public function shortcode_bold($atts = array(), $content = null)
    {
        return '<strong>' . $this->do_shortcode($content) . '</strong>';
    }
    
    public function shortcode_element($atts = array(), $content = null)
    {
        // http://cakephp.1045679.n5.nabble.com/rendering-elements-from-helpers-in-Cakephp2-td4912490.html
        $html = '';
        $element_name = 'shortcode/'.$atts['name'];
        if ($this->_View->elementExists($element_name)) {
            $html = $this->_View->element($element_name);
        }
        return $html;
    }
}
